"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchableMailbox = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const Guid_1 = require("../Guid");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents searchable mailbox object
 *
 * @sealed
 */
class SearchableMailbox {
    constructor(guid = null, smtpAddress = null, isExternalMailbox = false, externalEmailAddress = null, displayName = null, isMembershipGroup = false, referenceId = null) {
        /**
         * Guid
         */
        this.Guid = null;
        /**
         * Smtp address
         */
        this.SmtpAddress = null;
        /**
         * If true, this is an external mailbox
         */
        this.IsExternalMailbox = false;
        /**
         * External email address for the mailbox
         */
        this.ExternalEmailAddress = null;
        /**
         * Display name
         */
        this.DisplayName = null;
        /**
         * Is a membership group
         */
        this.IsMembershipGroup = false;
        /**
         * Reference id
         */
        this.ReferenceId = null;
        this.Guid = guid;
        this.SmtpAddress = smtpAddress;
        this.IsExternalMailbox = isExternalMailbox;
        this.ExternalEmailAddress = externalEmailAddress;
        this.DisplayName = displayName;
        this.IsMembershipGroup = isMembershipGroup;
        this.ReferenceId = referenceId;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     * @return  {SearchableMailbox}              Searchable mailbox object
     */
    static LoadFromXmlJsObject(jsObject, service) {
        let searchableMailbox = new SearchableMailbox();
        if (jsObject[XmlElementNames_1.XmlElementNames.Guid]) {
            searchableMailbox.Guid = new Guid_1.Guid(jsObject[XmlElementNames_1.XmlElementNames.Guid]);
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.DisplayName]) {
            searchableMailbox.DisplayName = jsObject[XmlElementNames_1.XmlElementNames.DisplayName];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.PrimarySmtpAddress]) {
            searchableMailbox.SmtpAddress = jsObject[XmlElementNames_1.XmlElementNames.PrimarySmtpAddress];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.IsExternalMailbox]) {
            searchableMailbox.IsExternalMailbox = ExtensionMethods_1.Convert.toBool(jsObject[XmlElementNames_1.XmlElementNames.IsExternalMailbox]);
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.ExternalEmailAddress]) {
            searchableMailbox.ExternalEmailAddress = jsObject[XmlElementNames_1.XmlElementNames.ExternalEmailAddress];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.IsMembershipGroup]) {
            searchableMailbox.IsMembershipGroup = ExtensionMethods_1.Convert.toBool(jsObject[XmlElementNames_1.XmlElementNames.IsMembershipGroup]);
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.ReferenceId]) {
            searchableMailbox.ReferenceId = jsObject[XmlElementNames_1.XmlElementNames.ReferenceId];
        }
        return searchableMailbox;
    }
}
exports.SearchableMailbox = SearchableMailbox;
//# sourceMappingURL=SearchableMailbox.js.map