"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNonIndexableItemDetailsParameters = exports.GetNonIndexableItemStatisticsParameters = exports.NonIndexableItemParameters = void 0;
/**
 * Represents non indexable item parameters base class
 */
class NonIndexableItemParameters {
    constructor() {
        /**
         * List of mailboxes (in legacy DN format)
         */
        this.Mailboxes = null;
        /**
         * Search archive only
         */
        this.SearchArchiveOnly = false;
    }
}
exports.NonIndexableItemParameters = NonIndexableItemParameters;
/**
 * Represents get non indexable item statistics parameters.
 *
 * @sealed
 */
class GetNonIndexableItemStatisticsParameters extends NonIndexableItemParameters {
}
exports.GetNonIndexableItemStatisticsParameters = GetNonIndexableItemStatisticsParameters;
/**
 * Represents get non indexable item details parameters.
 *
 * @sealed
 */
class GetNonIndexableItemDetailsParameters extends NonIndexableItemParameters {
    constructor() {
        super(...arguments);
        /**
         * @Nullable Page size
         */
        this.PageSize = null; //Nullable
        /**
         * Page item reference
         */
        this.PageItemReference = null;
        /**
         * @Nullable Search page direction
         */
        this.PageDirection = null; //Nullable
    }
}
exports.GetNonIndexableItemDetailsParameters = GetNonIndexableItemDetailsParameters;
//# sourceMappingURL=NonIndexableItemParameters.js.map