"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonIndexableItemDetailsResult = void 0;
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const FailedSearchMailbox_1 = require("./FailedSearchMailbox");
const NonIndexableItem_1 = require("./NonIndexableItem");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents non indexable item details result.
 *
 * @sealed
 */
class NonIndexableItemDetailsResult {
    constructor() {
        /**
         * Collection of items
         */
        this.Items = null;
        /**
         * Failed mailboxes
         */
        this.FailedMailboxes = null;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     * @return  {NonIndexableItemDetailsResult}       Non indexable item details result object
     */
    static LoadFromXmlJsObject(jsObject, service) {
        let nonIndexableItemDetailsResult = new NonIndexableItemDetailsResult();
        if (jsObject[XmlElementNames_1.XmlElementNames.Items]) {
            nonIndexableItemDetailsResult.Items = [];
            for (let nonIndexableItem of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.Items], XmlElementNames_1.XmlElementNames.NonIndexableItemDetail)) {
                nonIndexableItemDetailsResult.Items.push(NonIndexableItem_1.NonIndexableItem.LoadFromXmlJsObject(nonIndexableItem, service));
            }
            if (nonIndexableItemDetailsResult.Items.length === 0) {
                nonIndexableItemDetailsResult.Items = null;
            }
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.FailedMailboxes]) {
            nonIndexableItemDetailsResult.FailedMailboxes = FailedSearchMailbox_1.FailedSearchMailbox.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.FailedMailboxes], service);
        }
        return nonIndexableItemDetailsResult;
    }
}
exports.NonIndexableItemDetailsResult = NonIndexableItemDetailsResult;
//# sourceMappingURL=NonIndexableItemDetailsResult.js.map