"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Guid = void 0;
const uuid_1 = require("uuid");
const EwsLogging_1 = require("./Core/EwsLogging");
const ExtensionMethods_1 = require("./ExtensionMethods");
/** Guid proxy class */
class Guid {
    constructor(str) {
        this.guid = '00000000-0000-0000-0000-000000000000';
        let regxStrict = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
        let regxRelax = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
        if (arguments.length > 0) {
            if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(str) || str === null) {
                throw new TypeError("Guid.ctor - invalid input");
            }
            //str = str.replace("-", "").replace("{", "").replace("}", "").toLowerCase();
            str = str.replace("{", "").replace("}", "").toLowerCase();
            if (regxStrict.test(str)) {
                this.guid = str;
            }
            else {
                if (!Guid.ParseStrict && regxRelax.test(str)) {
                    EwsLogging_1.EwsLogging.DebugLog("info: Guid.ctor - guid is in generic format. if you want to error on non uuid v4 format, set `Guid.ParseStrict = true`");
                    this.guid = str;
                }
                else {
                    throw new TypeError("Guid.ctor - invalid input, input not of type uuid v4");
                }
            }
        }
    }
    ToString() {
        return this.guid;
    }
    toString() {
        return this.guid;
    }
    static NewGuid() {
        return new Guid((0, uuid_1.v4)());
    }
    static Parse(str) {
        return new Guid(str);
    }
    static TryParse(str, _parsed_output = { guid: null }) {
        try {
            _parsed_output.guid = new Guid(str);
            return true;
        }
        catch (error) {
            return false;
        }
    }
}
exports.Guid = Guid;
Guid.ParseStrict = false;
Guid.Empty = new Guid();
//# sourceMappingURL=Guid.js.map