"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exception = void 0;
//make necessary changes if needed
//ref: 0.9 - extending Error as BlueBird throws error if promise is rejected without an Error object
class Exception {
    constructor(message = "", innerException = null) {
        /** @internal  */
        this.message = '';
        //todo: implement stacktrace and source if needed - stack trace implemented by calling Error.captureStack
        this.stack = null;
        this.InnerException = null;
        this.InnerException = innerException;
        this.message = message || "";
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(this, this.constructor);
        }
        else {
            this.stack = (new Error(message)).stack;
        }
        //this.name = this.constructor.name; - no need to capture Name, can be infered by checking instance of Exception (or inheriting class)
    }
    get Message() {
        return this.message;
    }
    /** @internal  needed for bluebird to work when rejected without inheriting from Error object. BlueBird checks for Error like object not Error subclass itself. */
    get name() {
        return 'Exception';
    }
    /**
     * @override user JSON.stringify for now, todo: impelemtn real Exception tostring
     */
    toString() {
        let result = this.stack;
        try {
            result = result || JSON.stringify(this);
        }
        catch (e) { }
        return result;
    }
    ToString() {
        return this.toString();
    }
}
exports.Exception = Exception;
//# sourceMappingURL=Exception.js.map