"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverRemoteException = void 0;
const AutodiscoverError_1 = require("../Autodiscover/AutodiscoverError");
const ServiceRemoteException_1 = require("./ServiceRemoteException");
/**
 * Represents an exception that is thrown when the Autodiscover service returns an error.
 */
class AutodiscoverRemoteException extends ServiceRemoteException_1.ServiceRemoteException {
    constructor(errorOrMessage, error = null, innerException = null) {
        let _error = null;
        let message = null;
        if (arguments.length === 1 && errorOrMessage instanceof AutodiscoverError_1.AutodiscoverError) {
            error = errorOrMessage;
        }
        if (arguments.length >= 2) {
            if (typeof errorOrMessage === 'string') {
                message = errorOrMessage;
                _error = error;
            }
        }
        super(message, innerException);
        this.error = _error;
    }
    /**
     * Gets the error.
     *  @value the Error
     */
    get Error() {
        return this.error;
    }
}
exports.AutodiscoverRemoteException = AutodiscoverRemoteException;
//# sourceMappingURL=AutodiscoverRemoteException.js.map