"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExchangeCredentials = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const Uri_1 = require("../Uri");
class ExchangeCredentials {
    constructor(userName = null, password = null) {
        this.UserName = null;
        if (arguments.length > 0 && (ExtensionMethods_1.StringHelper.IsNullOrEmpty(userName) || ExtensionMethods_1.StringHelper.IsNullOrEmpty(password))) {
            throw new Error("ExchangeCredentials.ctor, must provide username and password value.");
        }
        this.UserName = userName;
        var pwd = password;
        this.setPassword = (value) => { pwd = value; };
        this.getPassword = () => { return pwd; };
        //this.Password = password;
    }
    get Password() { return this.getPassword(); }
    set Password(value) { this.setPassword(value); }
    AdjustUrl(url) { return new Uri_1.Uri(ExchangeCredentials.GetUriWithoutSuffix(url)); }
    EmitExtraSoapHeaderNamespaceAliases(writer /*System.Xml.XmlWriter*/) { }
    static GetUriWithoutSuffix(url) {
        var absoluteUri = url.AbsoluteUri;
        //ref: can not use WSSecurityBasedCredentials.WsSecurityPathSuffix, creates circular reference.
        var index = absoluteUri.toUpperCase().indexOf(/*WSSecurityBasedCredentials*/ ExchangeCredentials.WsSecurityPathSuffix.toUpperCase()); //, StringComparison.OrdinalIgnoreCase);
        if (index != -1) {
            return absoluteUri.substring(0, index);
        }
        return absoluteUri;
    }
    //PreAuthenticate(): any{ throw new Error("ExchangeCredentials.ts - PreAuthenticate : Not implemented.");}
    PrepareWebRequest(request /*IEwsHttpWebRequest*/) {
        request.headers["Authorization"] = "Basic " + ExtensionMethods_1.base64Helper.btoa(this.UserName + ":" + this.Password);
    }
    SerializeExtraSoapHeaders(writer /*System.Xml.XmlWriter*/, webMethodName) { }
}
exports.ExchangeCredentials = ExchangeCredentials;
//NeedSignature: boolean;
ExchangeCredentials.WsSecurityPathSuffix = "/wssecurity";
//# sourceMappingURL=ExchangeCredentials.js.map