"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimplePropertyBag = void 0;
const EwsLogging_1 = require("./EwsLogging");
const ExtensionMethods_1 = require("../ExtensionMethods");
const AltDictionary_1 = require("../AltDictionary");
class SimplePropertyBag {
    constructor(keyPicker) {
        this.items = null;
        this.removedItems = [];
        this.addedItems = [];
        this.modifiedItems = [];
        this.OnChange = [];
        this.items = new AltDictionary_1.Dictionary(keyPicker);
    }
    get AddedItems() {
        return this.addedItems;
    }
    get RemovedItems() {
        return this.removedItems;
    }
    get ModifiedItems() {
        return this.modifiedItems;
    }
    _getItem(key) {
        var value = { outValue: null };
        if (this.TryGetValue(key, value)) {
            return value.outValue;
        }
        else {
            return null;
        }
    }
    _setItem(key, value) {
        if (value == null) {
            this.InternalRemoveItem(key);
        }
        else {
            // If the item was to be deleted, the deletion becomes an update.
            if (ExtensionMethods_1.ArrayHelper.RemoveEntry(this.removedItems, key)) {
                this.InternalAddItemToChangeList(key, this.modifiedItems);
            }
            else {
                // If the property value was not set, we have a newly set property.
                if (!this.ContainsKey(key)) {
                    this.InternalAddItemToChangeList(key, this.addedItems);
                }
                else {
                    // The last case is that we have a modified property.
                    if (this.modifiedItems.indexOf(key) === -1) {
                        this.InternalAddItemToChangeList(key, this.modifiedItems);
                    }
                }
            }
            this.items.set(key, value);
            this.Changed();
        }
    }
    Changed() {
        if (this.OnChange != null) {
            EwsLogging_1.EwsLogging.Assert(false, "SimplePropertyBag.Changed", "OnChange events not fired due to circular calling, todo: fix needed");
            return;
            for (var changeDelegate of this.OnChange) {
                changeDelegate();
            }
        }
    }
    ClearChangeLog() {
        this.removedItems.splice(0);
        this.addedItems.splice(0);
        this.modifiedItems.splice(0);
    }
    ContainsKey(key) { return this.items.containsKey(key); }
    GetEnumerator() { throw new Error("SimplePropertyBag.ts - GetEnumerator : Not implemented."); }
    InternalAddItemToChangeList(key, changeList) {
        if (changeList.indexOf(key) === -1) {
            changeList.push(key);
        }
    }
    InternalRemoveItem(key) {
        var value = { outValue: null };
        if (this.TryGetValue(key, value)) {
            this.items.remove(key);
            this.removedItems.push(key);
            this.Changed();
        }
    }
    TryGetValue(key, value) { return this.items.tryGetValue(key, value); }
}
exports.SimplePropertyBag = SimplePropertyBag;
//# sourceMappingURL=SimplePropertyBag.js.map