"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingResponseSchema = void 0;
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const Schemas_1 = require("./Schemas");
const ScopedDateTimePropertyDefinition_1 = require("../../../PropertyDefinitions/ScopedDateTimePropertyDefinition");
const XmlElementNames_1 = require("../../XmlElementNames");
const MeetingMessageSchema_1 = require("./MeetingMessageSchema");
/**
 * Field URIs for meeting response.
 */
var FieldUris;
(function (FieldUris) {
    FieldUris.ProposedStart = "meeting:ProposedStart";
    FieldUris.ProposedEnd = "meeting:ProposedEnd";
})(FieldUris || (FieldUris = {}));
/**
 * Represents the schema for meeting response
 */
class MeetingResponseSchema extends MeetingMessageSchema_1.MeetingMessageSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.Start);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.End);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.Location);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.Recurrence);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.AppointmentType);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.ProposedStart);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.ProposedEnd);
        this.RegisterProperty(MeetingResponseSchema, MeetingResponseSchema.EnhancedLocation);
    }
}
exports.MeetingResponseSchema = MeetingResponseSchema;
/**
 * Defines the **Start** property.
 */
MeetingResponseSchema.Start = Schemas_1.Schemas.AppointmentSchema.Start;
/**
 * Defines the **End** property.
 */
MeetingResponseSchema.End = Schemas_1.Schemas.AppointmentSchema.End;
/**
 * Defines the **Location** property.
 */
MeetingResponseSchema.Location = Schemas_1.Schemas.AppointmentSchema.Location;
/**
 * Defines the **AppointmentType** property.
 */
MeetingResponseSchema.AppointmentType = Schemas_1.Schemas.AppointmentSchema.AppointmentType;
/**
 * Defines the **Recurrence** property.
 */
MeetingResponseSchema.Recurrence = Schemas_1.Schemas.AppointmentSchema.Recurrence;
/**
 * Defines the **ProposedStart** property.
 */
MeetingResponseSchema.ProposedStart = new ScopedDateTimePropertyDefinition_1.ScopedDateTimePropertyDefinition("ProposedStart", XmlElementNames_1.XmlElementNames.ProposedStart, FieldUris.ProposedStart, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2013, (version) => { return Schemas_1.Schemas.AppointmentSchema.StartTimeZone; });
/**
 * Defines the **ProposedEnd** property.
 */
MeetingResponseSchema.ProposedEnd = new ScopedDateTimePropertyDefinition_1.ScopedDateTimePropertyDefinition("ProposedEnd", XmlElementNames_1.XmlElementNames.ProposedEnd, FieldUris.ProposedEnd, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2013, (version) => { return Schemas_1.Schemas.AppointmentSchema.EndTimeZone; });
/**
 * Defines the **EnhancedLocation** property.
 */
MeetingResponseSchema.EnhancedLocation = Schemas_1.Schemas.AppointmentSchema.EnhancedLocation;
/**
 * @internal Instance of **MeetingResponseSchema**
 */
MeetingResponseSchema.Instance = new MeetingResponseSchema();
//# sourceMappingURL=MeetingResponseSchema.js.map