"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveFromCalendar = void 0;
const EwsLogging_1 = require("../../EwsLogging");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const NotSupportedException_1 = require("../../../Exceptions/NotSupportedException");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const ServiceObject_1 = require("../ServiceObject");
/**
 * @internal Represents a response object created to remove a calendar item from a meeting cancellation.
 *
 * @sealed
 */
class RemoveFromCalendar extends ServiceObject_1.ServiceObject {
    /**
     * Initializes a new instance of the **RemoveFromCalendar** class.
     *
     * @param   {Item}   referenceItem   The reference item.
     */
    constructor(referenceItem) {
        super(referenceItem.Service);
        EwsLogging_1.EwsLogging.Assert(referenceItem != null, "RemoveFromCalendar.ctor", "referenceItem is null");
        referenceItem.ThrowIfThisIsNew();
        this.referenceItem = referenceItem;
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.ResponseObjectSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.RemoveItem;
    }
    /**
     * @internal Create response object.
     *
     * @param   {FolderId}              parentFolderId       The parent folder id.
     * @param   {MessageDisposition}    messageDisposition   The message disposition.
     * @return  {Item[]}                A list of items that were created or modified as a results of this operation.
     */
    InternalCreate(parentFolderId, messageDisposition) {
        this.PropertyBag._getItem(Schemas_1.Schemas.ResponseObjectSchema.ReferenceItemId).Assign(this.referenceItem.Id);
        return this.Service.InternalCreateResponseObject(this, parentFolderId, messageDisposition);
    }
    /**
     * @internal Deletes the object.
     *
     * @param   {DeleteMode}                deleteMode                The deletion mode.
     * @param   {SendCancellationsMode}     sendCancellationsMode     Indicates whether meeting cancellation messages should be sent.
     * @param   {AffectedTaskOccurrence}    affectedTaskOccurrences   Indicate which occurrence of a recurring task should be deleted.
     * @return  {Promise<void>}            :Promise.
     */
    InternalDelete(deleteMode, sendCancellationsMode, affectedTaskOccurrences) {
        throw new NotSupportedException_1.NotSupportedException();
    }
    /**
     * @internal Loads the specified set of properties on the object.
     *
     * @param   {PropertySet}   propertySet   The properties to load.
     * @return  {Promise<void>}              :Promise.
     */
    InternalLoad(propertySet) {
        throw new NotSupportedException_1.NotSupportedException();
    }
}
exports.RemoveFromCalendar = RemoveFromCalendar;
//# sourceMappingURL=RemoveFromCalendar.js.map