"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeclineMeetingInvitationMessage = void 0;
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../../XmlElementNames");
const CalendarResponseMessage_1 = require("./CalendarResponseMessage");
/**
 * Represents a meeting declination message.
 */
class DeclineMeetingInvitationMessage extends CalendarResponseMessage_1.CalendarResponseMessage {
    /**
     * Initializes a new instance of the **DeclineMeetingInvitationMessage** class.
     *
     * @param   {Item}   referenceItem   The reference item.
     */
    constructor(referenceItem) {
        super(referenceItem);
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.DeclineItem; }
}
exports.DeclineMeetingInvitationMessage = DeclineMeetingInvitationMessage;
//# sourceMappingURL=DeclineMeetingInvitationMessage.js.map