"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarResponseMessageBase = void 0;
const CalendarActionResults_1 = require("../../../Misc/CalendarActionResults");
const FolderId_1 = require("../../../ComplexProperties/FolderId");
const MessageDisposition_1 = require("../../../Enumerations/MessageDisposition");
const ResponseObject_1 = require("./ResponseObject");
/**
 * Represents the base class for all calendar-related response messages.
 *
 * @typeparam   {TMessage}     The type of message that is created when this response message is saved.
 */
class CalendarResponseMessageBase extends ResponseObject_1.ResponseObject {
    /**
    * @internal Initializes a new instance of the **CalendarResponseMessageBase** class.
    *
    * @param   {Item}   referenceItem   The reference item.
    */
    constructor(referenceItem) {
        super(referenceItem);
    }
    Save(destinationFolderIdOrName) {
        var destinationFolderId = null;
        if (arguments.length === 1) {
            if (typeof destinationFolderIdOrName === "number") {
                destinationFolderId = new FolderId_1.FolderId(destinationFolderIdOrName);
            }
            else {
                //EwsUtilities.ValidateParam(destinationFolderIdOrName, "destinationFolderId");
                destinationFolderId = destinationFolderIdOrName;
            }
        }
        return this.InternalCreate(destinationFolderId, MessageDisposition_1.MessageDisposition.SaveOnly).then((results) => {
            return new CalendarActionResults_1.CalendarActionResults(results);
        });
    }
    /**
     * Sends this response without saving a copy. Calling this method results in a call to EWS.
     *
     * @return  {CalendarActionResults}      A CalendarActionResults object containing the various items that were created or modified as a results of this operation.
     */
    Send() {
        return this.InternalCreate(null, MessageDisposition_1.MessageDisposition.SendOnly).then((results) => {
            return new CalendarActionResults_1.CalendarActionResults(results);
        });
    }
    SendAndSaveCopy(destinationFolderIdOrName) {
        var destinationFolderId = null;
        if (arguments.length === 1) {
            if (typeof destinationFolderIdOrName === "number") {
                destinationFolderId = new FolderId_1.FolderId(destinationFolderIdOrName);
            }
            else {
                //EwsUtilities.ValidateParam(destinationFolderIdOrName, "destinationFolderId");
                destinationFolderId = destinationFolderIdOrName;
            }
        }
        return this.InternalCreate(destinationFolderId, MessageDisposition_1.MessageDisposition.SendAndSaveCopy)
            .then((results) => {
            return new CalendarActionResults_1.CalendarActionResults(results);
        });
    }
}
exports.CalendarResponseMessageBase = CalendarResponseMessageBase;
//# sourceMappingURL=CalendarResponseMessageBase.js.map