"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcceptMeetingInvitationMessage = void 0;
const XmlElementNames_1 = require("../../XmlElementNames");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const CalendarResponseMessage_1 = require("./CalendarResponseMessage");
/**
 * Represents a meeting acceptance message.
 *
 */
class AcceptMeetingInvitationMessage extends CalendarResponseMessage_1.CalendarResponseMessage {
    /**
     * Initializes a new instance of the **AcceptMeetingInvitationMessage** class.
     *
     * @param   {Item}            referenceItem   The reference item.
     * @param   {boolean}         tentative       if set to true accept invitation tentatively.
     */
    constructor(referenceItem, tentative) {
        super(referenceItem);
        this.tentative = false;
        this.tentative = tentative;
    }
    /**
     * Gets a value indicating whether the associated meeting is tentatively accepted.
     *
     */
    get Tentative() {
        return this.tentative;
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal This methods lets subclasses of ServiceObject override the default mechanism by which the XML element name associated with their type is retrieved.
     *
     * @return  {string}      The XML element name associated with this type. If this method returns null or empty, the XML element name associated with this type is determined by the EwsObjectDefinition attribute that decorates the type, if present.
     */
    GetXmlElementNameOverride() {
        if (this.tentative) {
            return XmlElementNames_1.XmlElementNames.TentativelyAcceptItem;
        }
        else {
            return XmlElementNames_1.XmlElementNames.AcceptItem;
        }
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return this.GetXmlElementNameOverride(); }
}
exports.AcceptMeetingInvitationMessage = AcceptMeetingInvitationMessage;
//# sourceMappingURL=AcceptMeetingInvitationMessage.js.map