"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingResponse = void 0;
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const MeetingMessage_1 = require("./MeetingMessage");
/**
 * Represents a response to a meeting request. Properties available on meeting messages are defined in the MeetingMessageSchema class.
 */
class MeetingResponse extends MeetingMessage_1.MeetingMessage {
    /**
     * Gets the start time of the appointment.
     */
    get Start() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.Start);
    }
    /**
     * Gets the end time of the appointment.
     */
    get End() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.End);
    }
    /**
     * Gets the location of this appointment.
     */
    get Location() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.Location);
    }
    /**
     * Gets the recurrence pattern for this meeting request.
     */
    get Recurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Recurrence);
    }
    /**
     * Gets the proposed start time of the appointment.
     */
    get ProposedStart() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.ProposedStart);
    }
    /**
     * Gets the proposed end time of the appointment.
     */
    get ProposedEnd() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.ProposedEnd);
    }
    /**
     * Gets the Enhanced location object.
     */
    get EnhancedLocation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingResponseSchema.EnhancedLocation);
    }
    constructor(parentAttachmentOrService) {
        super(parentAttachmentOrService);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, MeetingResponse);
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.MeetingResponseSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.MeetingResponse; }
}
exports.MeetingResponse = MeetingResponse;
//# sourceMappingURL=MeetingResponse.js.map