"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TasksFolder = void 0;
const EwsLogging_1 = require("../../EwsLogging");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const FolderId_1 = require("../../../ComplexProperties/FolderId");
const PropertySet_1 = require("../../PropertySet");
const TypeContainer_1 = require("../../../TypeContainer");
const XmlElementNames_1 = require("../../XmlElementNames");
const Folder_1 = require("./Folder");
/**
 * Represents a folder containing task items.
 */
class TasksFolder extends Folder_1.Folder {
    /**
     * Initializes an unsaved local instance of **SearchFolder**. To bind to an existing contacts folder, use SearchFolder.Bind() instead.
     *
     * @param   {ExchangeService}   service   The ExchangeService object to which the contacts folder will be bound.
     */
    constructor(service) {
        super(service);
    }
    static Bind(service, idOrName, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        if (idOrName instanceof FolderId_1.FolderId) {
            return service.BindToFolder(idOrName, propertySet, TypeContainer_1.TypeContainer.TasksFolder);
        }
        else if (typeof idOrName === 'number') {
            return service.BindToFolder(new FolderId_1.FolderId(idOrName), propertySet, TypeContainer_1.TypeContainer.TasksFolder);
        }
        EwsLogging_1.EwsLogging.Assert(false, "TasksFolder.Bind", "unknown paramete type");
        throw new Error("unknow parameter type. this should not be  reached");
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.TasksFolder; }
}
exports.TasksFolder = TasksFolder;
//# sourceMappingURL=TasksFolder.js.map