"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarFolder = void 0;
const EwsLogging_1 = require("../../EwsLogging");
const EwsUtilities_1 = require("../../EwsUtilities");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const FolderId_1 = require("../../../ComplexProperties/FolderId");
const PropertySet_1 = require("../../PropertySet");
const TypeContainer_1 = require("../../../TypeContainer");
const XmlElementNames_1 = require("../../XmlElementNames");
const Folder_1 = require("./Folder");
/**
 * Represents a folder containing appointments.
 */
class CalendarFolder extends Folder_1.Folder {
    /**
     * Initializes an unsaved local instance of **CalendarFolder**. To bind to an existing calendar folder, use CalendarFolder.Bind() instead.
     *
     * @param   {ExchangeService}   service   The ExchangeService object to which the calendar folder will be bound.
     */
    constructor(service) {
        super(service);
    }
    static Bind(service, idOrName, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        if (idOrName instanceof FolderId_1.FolderId) {
            return service.BindToFolder(idOrName, propertySet, TypeContainer_1.TypeContainer.CalendarFolder);
        }
        else if (typeof idOrName === 'number') {
            return service.BindToFolder(new FolderId_1.FolderId(idOrName), propertySet, TypeContainer_1.TypeContainer.CalendarFolder);
        }
        EwsLogging_1.EwsLogging.Assert(false, "CalendarFolder.Bind", "unknown paramete type");
        throw new Error("unknow parameter type. this should not be  reached");
    }
    /**
     * Obtains a list of appointments by searching the contents of this folder and performing recurrence expansion for recurring appointments. Calling this method results in a call to EWS.
     *
     * @param   {CalendarView}   view   The view controlling the range of appointments returned.
     * @return  {FindItemsResults<Appointment>}          An object representing the results of the search operation.
     */
    FindAppointments(view) {
        EwsUtilities_1.EwsUtilities.ValidateParam(view, "view");
        return this.InternalFindItems(null, view, null /* groupBy */).then((responses) => {
            return responses.__thisIndexer(0).Results;
        });
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.CalendarFolder; }
}
exports.CalendarFolder = CalendarFolder;
//# sourceMappingURL=CalendarFolder.js.map