"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateFolderResponse = void 0;
const ServiceResult_1 = require("../../Enumerations/ServiceResult");
const EwsLogging_1 = require("../EwsLogging");
const ServiceResponse_1 = require("./ServiceResponse");
class UpdateFolderResponse extends ServiceResponse_1.ServiceResponse {
    constructor(folder) {
        super();
        EwsLogging_1.EwsLogging.Assert(folder != null, "UpdateFolderResponse.ctor", "folder is null");
        this.folder = folder;
    }
    GetObjectInstance(session, xmlElementName) { return this.folder; }
    Loaded() {
        if (this.Result == ServiceResult_1.ServiceResult.Success) {
            this.folder.ClearChangeLog();
        }
    }
    ReadElementsFromXmlJsObject(responseObject, service) {
        //debugger;//todo: check if this is needed. 
        //throw new Error("UpdateFolderResponse.ts - ReadElementsFromXmlJsObject : Not implemented."); 
    }
}
exports.UpdateFolderResponse = UpdateFolderResponse;
//# sourceMappingURL=UpdateFolderResponse.js.map