"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscribeResponse = void 0;
const EwsLogging_1 = require("../EwsLogging");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the base response class to subscription creation operations.
 *
 * @sealed
 * @typeparam	{TSubscription}		The type of the subscription.
 */
class SubscribeResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **SubscribeResponse<TSubscription>** class.
     *
     * @param   {TSubscription}   subscription   The subscription.
     */
    constructor(subscription) {
        super();
        EwsLogging_1.EwsLogging.Assert(subscription != null, "SubscribeResponse.ctor", "subscription is null");
        this.subscription = subscription;
    }
    /**
     * Gets the subscription that was created.
     */
    get Subscription() {
        return this.subscription;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               responseObject      The response object.
     * @param   {ExchangeService}   service             The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.subscription.LoadFromXmlJsObject(responseObject, service);
    }
}
exports.SubscribeResponse = SubscribeResponse;
//# sourceMappingURL=SubscribeResponse.js.map