"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetHoldOnMailboxesResponse = void 0;
const MailboxHoldResult_1 = require("../../MailboxSearch/MailboxHoldResult");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the SetHoldOnMailboxes response.
 *
 * @sealed
 */
class SetHoldOnMailboxesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **SetHoldOnMailboxesResponse** class.
     */
    constructor() {
        super();
        this.holdResult = null;
    }
    /**
     * Mailbox hold result
     */
    get HoldResult() {
        return this.holdResult;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        super.ReadElementsFromXmlJsObject(jsObject, service);
        if (jsObject[XmlElementNames_1.XmlElementNames.MailboxHoldResult]) {
            this.holdResult = MailboxHoldResult_1.MailboxHoldResult.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.MailboxHoldResult], service);
        }
    }
}
exports.SetHoldOnMailboxesResponse = SetHoldOnMailboxesResponse;
//# sourceMappingURL=SetHoldOnMailboxesResponse.js.map