"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolveNamesResponse = void 0;
const ServiceError_1 = require("../../Enumerations/ServiceError");
const XmlElementNames_1 = require("../XmlElementNames");
const NameResolutionCollection_1 = require("../../Misc/NameResolutionCollection");
const EwsLogging_1 = require("../EwsLogging");
const ServiceResponse_1 = require("./ServiceResponse");
class ResolveNamesResponse extends ServiceResponse_1.ServiceResponse {
    constructor(service) {
        super();
        this.resolutions = null;
        EwsLogging_1.EwsLogging.Assert(service !== null, "ResolveNamesResponse.ctor", "service is null");
        this.resolutions = new NameResolutionCollection_1.NameResolutionCollection(service);
    }
    get Resolutions() {
        return this.resolutions;
    }
    InternalThrowIfNecessary() {
        if (this.ErrorCode != ServiceError_1.ServiceError.ErrorNameResolutionNoResults) {
            super.InternalThrowIfNecessary();
        }
    }
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.Resolutions.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.ResolutionSet], service);
    }
}
exports.ResolveNamesResponse = ResolveNamesResponse;
//# sourceMappingURL=ResolveNamesResponse.js.map