"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetStreamingEventsResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const GetStreamingEventsResults_1 = require("../../Notifications/GetStreamingEventsResults");
const HangingRequestDisconnectReason_1 = require("../../Enumerations/HangingRequestDisconnectReason");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Enumeration of ConnectionStatus that can be returned by the server.
 */
var ConnectionStatus;
(function (ConnectionStatus) {
    ConnectionStatus[ConnectionStatus["OK"] = 0] = "OK";
    ConnectionStatus[ConnectionStatus["Closed"] = 1] = "Closed";
})(ConnectionStatus || (ConnectionStatus = {}));
/**
 * @internal Represents the response to a subscription event retrieval operation.
 *
 * @sealed
 */
class GetStreamingEventsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * Initializes a new instance of the **GetStreamingEventsResponse** class.
     *
     * @param   {HangingServiceRequestBase}   request   Request to disconnect when we get a close message.
     */
    constructor(request) {
        super();
        this.results = new GetStreamingEventsResults_1.GetStreamingEventsResults();
        this.request = null;
        /**
         * Gets the error subscription ids.
         *
         * @private set
         * @value	The error subscription ids.
         */
        this.ErrorSubscriptionIds = [];
        this.ErrorSubscriptionIds = [];
        this.request = request;
    }
    /**
     * Gets event results from subscription.
     */
    get Results() {
        return this.results;
    }
    /**
     * @internal Loads extra error details from XML
     *
     * @param   {any}   			responseObject      Json Object converted from XML.
     * @param   {ExchangeService}   service             The service.
     */
    LoadExtraErrorDetailsFromXmlJsObject(responseObject, service) {
        super.LoadExtraErrorDetailsFromXmlJsObject(responseObject, service);
        if (responseObject[XmlElementNames_1.XmlElementNames.ErrorSubscriptionIds]) {
            let errorSubscriptionIds = responseObject[XmlElementNames_1.XmlElementNames.ErrorSubscriptionIds];
            if (errorSubscriptionIds[XmlElementNames_1.XmlElementNames.SubscriptionId]) {
                let subscriptionIds = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(errorSubscriptionIds, XmlElementNames_1.XmlElementNames.SubscriptionId);
                subscriptionIds.forEach((subscriptionId) => {
                    this.ErrorSubscriptionIds.push(subscriptionId);
                });
            }
        }
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.Notifications]) {
            this.results.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.Notifications], service);
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.ConnectionStatus]) {
            let connectionStatus = jsObject[XmlElementNames_1.XmlElementNames.ConnectionStatus];
            if (connectionStatus === ConnectionStatus[ConnectionStatus.Closed]) {
                this.request.Disconnect(HangingRequestDisconnectReason_1.HangingRequestDisconnectReason.Clean, null);
            }
        }
    }
}
exports.GetStreamingEventsResponse = GetStreamingEventsResponse;
//# sourceMappingURL=GetStreamingEventsResponse.js.map