"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetRoomsResponse = void 0;
const EmailAddress_1 = require("../../ComplexProperties/EmailAddress");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a GetRooms operation.
 *
 * @sealed
 */
class GetRoomsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetRoomsResponse** class.
     */
    constructor() {
        super();
        this.rooms = [];
    }
    /**
     * Gets collection for all rooms returned
     */
    get Rooms() {
        return this.rooms;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.rooms.splice(0);
        let responses = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.Rooms], XmlElementNames_1.XmlElementNames.Room);
        for (let response of responses) {
            let emailAddress = new EmailAddress_1.EmailAddress();
            emailAddress.LoadFromXmlJsObject(response[XmlElementNames_1.XmlElementNames.RoomId], service);
            this.rooms.push(emailAddress);
        }
    }
}
exports.GetRoomsResponse = GetRoomsResponse;
//# sourceMappingURL=GetRoomsResponse.js.map