"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNonIndexableItemStatisticsResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const NonIndexableItemStatistic_1 = require("../../MailboxSearch/NonIndexableItemStatistic");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the GetNonIndexableItemStatistics response.
 *
 * @sealed
 */
class GetNonIndexableItemStatisticsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetNonIndexableItemStatisticsResponse** class.
     */
    constructor() {
        super();
        /**
         * List of non indexable statistic
         */
        this.NonIndexableStatistics = null;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        //super.ReadElementsFromXmlJsObject(jsObject,service);
        this.NonIndexableStatistics = [];
        if (jsObject[XmlElementNames_1.XmlElementNames.NonIndexableItemStatistics]) {
            for (let nonIndexableItemStatistic of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.NonIndexableItemStatistics], XmlElementNames_1.XmlElementNames.NonIndexableItemStatistic)) {
                this.NonIndexableStatistics.push(NonIndexableItemStatistic_1.NonIndexableItemStatistic.LoadFromXmlJsObject(nonIndexableItemStatistic, service));
            }
        }
    }
}
exports.GetNonIndexableItemStatisticsResponse = GetNonIndexableItemStatisticsResponse;
//# sourceMappingURL=GetNonIndexableItemStatisticsResponse.js.map