"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDelegateResponse = void 0;
const MeetingRequestsDeliveryScope_1 = require("../../Enumerations/MeetingRequestsDeliveryScope");
const ServiceError_1 = require("../../Enumerations/ServiceError");
const XmlElementNames_1 = require("../XmlElementNames");
const DelegateManagementResponse_1 = require("./DelegateManagementResponse");
/**
 * @internal Represents the response to a delegate user retrieval operation.
 *
 * @sealed
 */
class GetDelegateResponse extends DelegateManagementResponse_1.DelegateManagementResponse {
    /**
     * @internal Initializes a new instance of the **GetDelegateResponse** class.
     *
     * @param   {boolean}   readDelegateUsers   if set to *true* [read delegate users].
     */
    constructor(readDelegateUsers) {
        super(readDelegateUsers, null);
        this.meetingRequestsDeliveryScope = MeetingRequestsDeliveryScope_1.MeetingRequestsDeliveryScope.NoForward;
    }
    /**
     * @internal Gets a value indicating if and how meeting requests are delivered to delegates.
     */
    get MeetingRequestsDeliveryScope() {
        return this.meetingRequestsDeliveryScope;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        super.ReadElementsFromXmlJsObject(responseObject, service);
        if (this.ErrorCode == ServiceError_1.ServiceError.NoError) {
            if (responseObject[XmlElementNames_1.XmlElementNames.DeliverMeetingRequests]) {
                this.meetingRequestsDeliveryScope = MeetingRequestsDeliveryScope_1.MeetingRequestsDeliveryScope[responseObject[XmlElementNames_1.XmlElementNames.DeliverMeetingRequests]];
            }
        }
    }
}
exports.GetDelegateResponse = GetDelegateResponse;
//# sourceMappingURL=GetDelegateResponse.js.map