"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetConversationItemsResponse = void 0;
const ConversationResponse_1 = require("../../ComplexProperties/ConversationResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the response to a GetConversationItems operation.
 *
 * @sealed
 */
class GetConversationItemsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetConversationItemsResponse** class.
     *
     * @param   {PropertySet}   propertySet   The property set.
     */
    constructor(propertySet) {
        super();
        this.propertySet = propertySet;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.Conversation = new ConversationResponse_1.ConversationResponse(this.propertySet);
        this.Conversation.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.Conversation], service);
    }
}
exports.GetConversationItemsResponse = GetConversationItemsResponse;
//# sourceMappingURL=GetConversationItemsResponse.js.map