"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindFolderResponse = void 0;
const ServiceResponse_1 = require("./ServiceResponse");
const FindFoldersResults_1 = require("../../Search/FindFoldersResults");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const FolderInfo_1 = require("../ServiceObjects/Folders/FolderInfo");
const EwsLogging_1 = require("../EwsLogging");
class FindFolderResponse extends ServiceResponse_1.ServiceResponse {
    constructor(propertySet) {
        super();
        this.results = new FindFoldersResults_1.FindFoldersResults();
        this.propertySet = propertySet;
        EwsLogging_1.EwsLogging.Assert(this.propertySet != null, "FindFolderResponse.ctor", "PropertySet should not be null");
    }
    get Results() { return this.results; }
    CreateFolderInstance(service, xmlElementName) {
        var flinfo = new FolderInfo_1.FolderInfo();
        return flinfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
    }
    ReadElementsFromJson(responseObject, service) { throw new Error("FindFolderResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        var rootFolder = responseObject[XmlElementNames_1.XmlElementNames.RootFolder];
        this.results.TotalCount = Number(rootFolder[XmlAttributeNames_1.XmlAttributeNames.TotalItemsInView]);
        this.results.MoreAvailable = !ExtensionMethods_1.Convert.toBool(rootFolder[XmlAttributeNames_1.XmlAttributeNames.IncludesLastItemInRange]);
        // Ignore IndexedPagingOffset attribute if moreItemsAvailable is false.
        var nextPageOffset = null;
        if (this.results.MoreAvailable) {
            if (rootFolder[XmlAttributeNames_1.XmlAttributeNames.IndexedPagingOffset]) {
                nextPageOffset = Number(rootFolder[XmlAttributeNames_1.XmlAttributeNames.IndexedPagingOffset]);
            }
        }
        if (rootFolder[XmlElementNames_1.XmlElementNames.Folders]) {
            var folders = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(rootFolder, service, XmlElementNames_1.XmlElementNames.Folders, this.CreateFolderInstance, true, /* clearPropertyBag */ this.propertySet, /* requestedPropertySet */ true); /* summaryPropertiesOnly */
            folders.forEach((item, index) => { this.results.Folders.push(item); });
        }
    }
}
exports.FindFolderResponse = FindFolderResponse;
//# sourceMappingURL=FindFolderResponse.js.map