"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindConversationResponse = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsLogging_1 = require("../EwsLogging");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const FindConversationResults_1 = require("../../Search/FindConversationResults");
const HighlightTerm_1 = require("../../ComplexProperties/HighlightTerm");
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a Conversation search operation.
 *
 * @sealed
 */
class FindConversationResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **FindConversationResponse** class.
     */
    constructor() {
        super();
        this.Results = new FindConversationResults_1.FindConversationResults();
    }
    /**
     * @internal Gets the collection of conversations in results.
     */
    get Conversations() {
        return this.Results.Conversations;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        EwsLogging_1.EwsLogging.Assert(this.Results.Conversations != null, "FindConversationResponse.ReadElementsFromXml", "conversations is null.");
        EwsLogging_1.EwsLogging.Assert(this.Results.HighlightTerms != null, "FindConversationResponse.ReadElementsFromXml", "highlightTerms is null.");
        if (responseObject[XmlElementNames_1.XmlElementNames.Conversations]) {
            for (let conversationObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.Conversations], XmlElementNames_1.XmlElementNames.Conversation)) {
                let jsonConversation = conversationObject; // as JsonObject;
                let item = (new ItemInfo_1.ItemInfo()).CreateEwsObjectFromXmlElementName(service, XmlElementNames_1.XmlElementNames.Conversation);
                if (item != null) {
                    item.LoadFromXmlJsObject(jsonConversation, service, true, null, false);
                    this.Conversations.push(item);
                }
            }
        }
        if (responseObject[XmlElementNames_1.XmlElementNames.HighlightTerms]) {
            let highlightTermObjects = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.HighlightTerms], XmlElementNames_1.XmlElementNames.HighlightTerm);
            if (highlightTermObjects != null) {
                for (let highlightTermObject of highlightTermObjects) {
                    let jsonHighlightTerm = highlightTermObject; // as JsonObject;
                    let term = new HighlightTerm_1.HighlightTerm();
                    term.LoadFromXmlJsObject(jsonHighlightTerm, service);
                    this.Results.HighlightTerms.push(term);
                }
            }
        }
        if (responseObject[XmlElementNames_1.XmlElementNames.TotalConversationsInView]) {
            this.Results.TotalCount = ExtensionMethods_1.Convert.toNumber(responseObject[XmlElementNames_1.XmlElementNames.TotalConversationsInView]);
        }
        if (responseObject[XmlElementNames_1.XmlElementNames.IndexedOffset]) {
            this.Results.IndexedOffset = ExtensionMethods_1.Convert.toNumber(responseObject[XmlElementNames_1.XmlElementNames.IndexedOffset]);
        }
    }
}
exports.FindConversationResponse = FindConversationResponse;
//# sourceMappingURL=FindConversationResponse.js.map