"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegateUserResponse = void 0;
const DelegateUser_1 = require("../../ComplexProperties/DelegateUser");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the response to an individual delegate user manipulation (add, remove, update) operation.
 *
 * @sealed
 */
class DelegateUserResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **DelegateUserResponse** class.
     *
     * @param   {boolean}       readDelegateUsers   if set to *true* [read delegate users].
     * @param   {DelegateUser}  delegateUser        Existing DelegateUser to use (may be null).
     */
    constructor(readDelegateUser, delegateUser) {
        super();
        this.readDelegateUser = false;
        this.delegateUser = null;
        this.readDelegateUser = readDelegateUser;
        this.delegateUser = delegateUser;
    }
    /**
     * The delegate user that was involved in the operation.
     */
    get DelegateUser() {
        return this.delegateUser;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (this.readDelegateUser) {
            if (this.delegateUser == null) {
                this.delegateUser = new DelegateUser_1.DelegateUser();
            }
            this.delegateUser.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.DelegateUser], service);
        }
    }
}
exports.DelegateUserResponse = DelegateUserResponse;
//# sourceMappingURL=DelegateUserResponse.js.map