"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegateManagementResponse = void 0;
const DelegateUserResponse_1 = require("./DelegateUserResponse");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const ServiceError_1 = require("../../Enumerations/ServiceError");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a delegate managent-related operation.
 */
class DelegateManagementResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **DelegateManagementResponse** class.
     *
     * @param   {boolean}           readDelegateUsers   if set to *true* [read delegate users].
     * @param   {DelegateUser[]}    delegateUsers       List of existing delegate users to load.
     */
    constructor(readDelegateUsers, delegateUsers) {
        super();
        this.readDelegateUsers = false;
        this.delegateUsers = null;
        this.delegateUserResponses = null;
        this.readDelegateUsers = readDelegateUsers;
        this.delegateUsers = delegateUsers;
    }
    /**
     * @internal Gets a collection of responses for each of the delegate users concerned by the operation.
     */
    get DelegateUserResponses() {
        return this.delegateUserResponses;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (this.ErrorCode === ServiceError_1.ServiceError.NoError) {
            this.delegateUserResponses = [];
        }
        let jsResponses = responseObject[XmlElementNames_1.XmlElementNames.ResponseMessages];
        let delegateUserIndex = 0;
        for (let jsResponse of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsResponses, XmlElementNames_1.XmlElementNames.DelegateUserResponseMessageType)) {
            let delegateUser = null;
            if (this.readDelegateUsers && (this.delegateUsers != null)) {
                delegateUser = this.delegateUsers[delegateUserIndex];
            }
            let delegateUserResponse = new DelegateUserResponse_1.DelegateUserResponse(this.readDelegateUsers, delegateUser);
            delegateUserResponse.LoadFromXmlJsObject(jsResponse, service);
            this.delegateUserResponses.push(delegateUserResponse);
            delegateUserIndex++;
        }
    }
}
exports.DelegateManagementResponse = DelegateManagementResponse;
//# sourceMappingURL=DelegateManagementResponse.js.map