"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConvertIdResponse = void 0;
const AlternateId_1 = require("../../Misc/IdConversion/AlternateId");
const AlternatePublicFolderId_1 = require("../../Misc/IdConversion/AlternatePublicFolderId");
const AlternatePublicFolderItemId_1 = require("../../Misc/IdConversion/AlternatePublicFolderItemId");
const EwsLogging_1 = require("../EwsLogging");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the response to an individual Id conversion operation.
 *
 * @sealed
 */
class ConvertIdResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **ConvertIdResponse** class.
     */
    constructor() {
        super();
    }
    /**
     * Gets the converted Id.
     */
    get ConvertedId() {
        return this.convertedId;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        let responseObject = jsObject[XmlElementNames_1.XmlElementNames.AlternateId];
        let alternateIdClass = responseObject[XmlAttributeNames_1.XmlAttributeNames.Type];
        if (alternateIdClass) {
            alternateIdClass = alternateIdClass.replace("t:", "");
        }
        switch (alternateIdClass) {
            case AlternateId_1.AlternateId.SchemaTypeName:
                this.convertedId = new AlternateId_1.AlternateId();
                break;
            case AlternatePublicFolderId_1.AlternatePublicFolderId.SchemaTypeName:
                this.convertedId = new AlternatePublicFolderId_1.AlternatePublicFolderId();
                break;
            case AlternatePublicFolderItemId_1.AlternatePublicFolderItemId.SchemaTypeName:
                this.convertedId = new AlternatePublicFolderItemId_1.AlternatePublicFolderItemId();
                break;
            default:
                EwsLogging_1.EwsLogging.Assert(false, "ConvertIdResponse.ReadElementsFromXml", ExtensionMethods_1.StringHelper.Format("Unknown alternate Id class: {0}", alternateIdClass));
                break;
        }
        this.convertedId.LoadAttributesFromXmlJsObject(responseObject);
    }
}
exports.ConvertIdResponse = ConvertIdResponse;
//# sourceMappingURL=ConvertIdResponse.js.map