"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttendeeAvailability = void 0;
const CalendarEvent_1 = require("../../ComplexProperties/Availability/CalendarEvent");
const WorkingHours_1 = require("../../ComplexProperties/Availability/WorkingHours");
const FreeBusyViewType_1 = require("../../Enumerations/FreeBusyViewType");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
class AttendeeAvailability extends ServiceResponse_1.ServiceResponse {
    constructor() {
        super(...arguments);
        this.calendarEvents = [];
        this.mergedFreeBusyStatus = [];
        this.viewType = FreeBusyViewType_1.FreeBusyViewType.None;
        this.workingHours = null;
    }
    get CalendarEvents() { return this.calendarEvents; }
    get ViewType() { return this.viewType; }
    get MergedFreeBusyStatus() { return this.mergedFreeBusyStatus; }
    get WorkingHours() { return this.workingHours; }
    LoadFreeBusyViewFromXmlJsObject(jsObject, viewType, service) {
        var viewTypeString = jsObject[XmlElementNames_1.XmlElementNames.FreeBusyViewType];
        this.viewType = FreeBusyViewType_1.FreeBusyViewType[viewTypeString];
        for (var key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.MergedFreeBusy:
                    var mergedFreeBusy = jsObject[key];
                    for (var status of mergedFreeBusy.split('')) {
                        this.mergedFreeBusyStatus.push(Number(status));
                    }
                    break;
                case XmlElementNames_1.XmlElementNames.CalendarEventArray:
                    var calendarEventArray = jsObject[key];
                    if (!calendarEventArray)
                        break;
                    var calendarEvents = calendarEventArray[XmlElementNames_1.XmlElementNames.CalendarEvent];
                    if (!Array.isArray(calendarEvents)) {
                        calendarEvents = [calendarEvents];
                    }
                    for (var calendarEventObj of calendarEvents) {
                        var calendarEvent = new CalendarEvent_1.CalendarEvent();
                        calendarEvent.LoadFromXmlJsObject(calendarEventObj, service);
                        this.calendarEvents.push(calendarEvent);
                    }
                    break;
                case XmlElementNames_1.XmlElementNames.WorkingHours:
                    this.workingHours = new WorkingHours_1.WorkingHours();
                    this.workingHours.LoadFromXmlJsObject(jsObject[key], service);
                    break;
            }
        }
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
    }
}
exports.AttendeeAvailability = AttendeeAvailability;
//# sourceMappingURL=AttendeeAvailability.js.map