"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArchiveItemResponse = void 0;
const ServiceResponse_1 = require("./ServiceResponse");
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const XmlElementNames_1 = require("../XmlElementNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
class ArchiveItemResponse extends ServiceResponse_1.ServiceResponse {
    GetObjectInstance(service, xmlElementName) {
        return (new ItemInfo_1.ItemInfo()).CreateEwsObjectFromXmlElementName(service, xmlElementName);
    }
    ReadElementsFromJson(responseObject, service) { throw new Error("ArchiveItemResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        //debugger;
        var items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Folders, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
        if (items.length > 0) {
            this.item = items[0];
        }
    }
}
exports.ArchiveItemResponse = ArchiveItemResponse;
//# sourceMappingURL=ArchiveItemResponse.js.map