"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateUserConfigurationRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a UpdateUserConfiguration request.
 */
class UpdateUserConfigurationRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **UpdateUserConfigurationRequest** class.
     *
     * @param   {ExchangeService}       service   The service.
     */
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.userConfiguration = null;
    }
    /**
     * Gets or sets the user configuration.
     *
     * @value   The userConfiguration.
     */
    get UserConfiguration() {
        return this.userConfiguration;
    }
    set UserConfiguration(value) {
        this.userConfiguration = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {ServiceResponse}	Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new ServiceResponse_1.ServiceResponse();
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return 1;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UpdateUserConfigurationResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UpdateUserConfigurationResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UpdateUserConfiguration;
    }
    /**
     * @internal Validate the request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.userConfiguration, "userConfiguration");
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        // Write UserConfiguation element
        this.userConfiguration.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.UserConfiguration);
    }
}
exports.UpdateUserConfigurationRequest = UpdateUserConfigurationRequest;
//# sourceMappingURL=UpdateUserConfigurationRequest.js.map