"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateItemRequest = void 0;
const MessageDisposition_1 = require("../../Enumerations/MessageDisposition");
const ConflictResolutionMode_1 = require("../../Enumerations/ConflictResolutionMode");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SendInvitationsOrCancellationsMode_1 = require("../../Enumerations/SendInvitationsOrCancellationsMode");
const ServiceVersionException_1 = require("../../Exceptions/ServiceVersionException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const Strings_1 = require("../../Strings");
const UpdateItemResponse_1 = require("../Responses/UpdateItemResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class UpdateItemRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        this.items = [];
        this.savedItemsDestinationFolder = null;
        this.conflictResolutionMode = 0;
        this.messageDisposition = null;
        this.sendInvitationsOrCancellationsMode = null;
        this.SuppressReadReceipts = false;
    }
    get EmitTimeZoneHeader() {
        for (var item of this.Items) {
            if (item.GetIsTimeZoneHeaderRequired(true /* isUpdateOpeartion */)) {
                return true;
            }
        }
        return false;
    }
    get MessageDisposition() {
        return this.messageDisposition;
    }
    set MessageDisposition(value) {
        this.messageDisposition = value;
    }
    get ConflictResolutionMode() {
        return this.conflictResolutionMode;
    }
    set ConflictResolutionMode(value) {
        this.conflictResolutionMode = value;
    }
    get SendInvitationsOrCancellationsMode() {
        return this.sendInvitationsOrCancellationsMode;
    }
    set SendInvitationsOrCancellationsMode(value) {
        this.sendInvitationsOrCancellationsMode = value;
    }
    get Items() {
        return this.items;
    }
    get SavedItemsDestinationFolder() {
        return this.savedItemsDestinationFolder;
    }
    set SavedItemsDestinationFolder(value) {
        this.savedItemsDestinationFolder = value;
    }
    CreateServiceResponse(service, responseIndex) { return new UpdateItemResponse_1.UpdateItemResponse(this.Items[responseIndex]); }
    GetExpectedResponseMessageCount() { return this.items.length; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.UpdateItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.UpdateItemResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.UpdateItem; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParamCollection(this.Items, "Items");
        for (var i = 0; i < this.Items.length; i++) {
            if ((this.Items[i] == null) || this.Items[i].IsNew) {
                throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ItemToUpdateCannotBeNullOrNew, i)); //ArgumentException
            }
        }
        if (this.SavedItemsDestinationFolder != null) {
            this.SavedItemsDestinationFolder.Validate(this.Service.RequestedServerVersion);
        }
        // Validate each item.
        for (var item of this.Items) {
            item.Validate();
        }
        if (this.SuppressReadReceipts && this.Service.RequestedServerVersion < ExchangeVersion_1.ExchangeVersion.Exchange2013) {
            throw new ServiceVersionException_1.ServiceVersionException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ParameterIncompatibleWithRequestVersion, "SuppressReadReceipts", ExchangeVersion_1.ExchangeVersion[ExchangeVersion_1.ExchangeVersion.Exchange2013]));
        }
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        if (this.MessageDisposition !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.MessageDisposition, MessageDisposition_1.MessageDisposition[this.MessageDisposition]);
        }
        if (this.SuppressReadReceipts) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SuppressReadReceipts, true);
        }
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.ConflictResolution, ConflictResolutionMode_1.ConflictResolutionMode[this.ConflictResolutionMode]);
        if (this.SendInvitationsOrCancellationsMode !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SendMeetingInvitationsOrCancellations, SendInvitationsOrCancellationsMode_1.SendInvitationsOrCancellationsMode[this.SendInvitationsOrCancellationsMode]);
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        if (this.SavedItemsDestinationFolder != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SavedItemFolderId);
            this.SavedItemsDestinationFolder.WriteToXml(writer);
            writer.WriteEndElement();
        }
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemChanges);
        for (var item of this.items) {
            item.WriteToXmlForUpdate(writer);
        }
        writer.WriteEndElement();
    }
}
exports.UpdateItemRequest = UpdateItemRequest;
//# sourceMappingURL=UpdateItemRequest.js.map