"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDelegateRequest = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MeetingRequestsDeliveryScope_1 = require("../../Enumerations/MeetingRequestsDeliveryScope");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const DelegateManagementResponse_1 = require("../Responses/DelegateManagementResponse");
const DelegateManagementRequestBase_1 = require("./DelegateManagementRequestBase");
/**
 * @internal Represents an UpdateDelegate request.
 */
class UpdateDelegateRequest extends DelegateManagementRequestBase_1.DelegateManagementRequestBase {
    /**
     * @internal Initializes a new instance of the **UpdateDelegateRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.delegateUsers = [];
        this.meetingRequestsDeliveryScope = null; //Nullable
    }
    /**
     * Gets or sets the meeting requests delivery scope.
     *
     * @value   The meeting requests delivery scope.
     */
    get MeetingRequestsDeliveryScope() {
        return this.meetingRequestsDeliveryScope;
    }
    set MeetingRequestsDeliveryScope(value) {
        this.meetingRequestsDeliveryScope = value;
    }
    /**
     * Gets the delegate users.
     *
     * @value   The delegate users.
     */
    get DelegateUsers() {
        return this.delegateUsers;
    }
    /**
     * @internal Creates the response
     *
     * @return  {DelegateManagementResponse}		Response object.
     */
    CreateResponse() {
        return new DelegateManagementResponse_1.DelegateManagementResponse(true, this.delegateUsers);
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UpdateDelegateResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UpdateDelegate;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParamCollection(this.DelegateUsers, "DelegateUsers");
        for (let delegateUser of this.DelegateUsers) {
            delegateUser.ValidateUpdateDelegate();
        }
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.DelegateUsers);
        for (let delegateUser of this.DelegateUsers) {
            delegateUser.WriteToXml(writer, XmlElementNames_1.XmlElementNames.DelegateUser);
        }
        writer.WriteEndElement(); // DelegateUsers
        if ((0, ExtensionMethods_1.hasValue)(this.MeetingRequestsDeliveryScope)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.DeliverMeetingRequests, MeetingRequestsDeliveryScope_1.MeetingRequestsDeliveryScope[this.MeetingRequestsDeliveryScope]);
        }
    }
}
exports.UpdateDelegateRequest = UpdateDelegateRequest;
//# sourceMappingURL=UpdateDelegateRequest.js.map