"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendItemRequest = void 0;
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class SendItemRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        this.items = [];
        this.savedCopyDestinationFolderId = null;
    }
    get Items() {
        return this.items;
    }
    set Items(value) {
        this.items = value;
    }
    get SavedCopyDestinationFolderId() {
        return this.savedCopyDestinationFolderId;
    }
    set SavedCopyDestinationFolderId(value) {
        this.savedCopyDestinationFolderId = value;
    }
    CreateServiceResponse(service, responseIndex) { return new ServiceResponse_1.ServiceResponse(); }
    GetExpectedResponseMessageCount() { return this.items.length; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.SendItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.SendItemResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.SendItem; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.Items, "Items");
        if (this.SavedCopyDestinationFolderId != null) {
            this.SavedCopyDestinationFolderId.Validate(this.Service.RequestedServerVersion);
        }
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SaveItemToFolder, this.SavedCopyDestinationFolderId != null);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds);
        for (var item of this.items) {
            item.Id.WriteToXml(writer); //, XmlElementNames.ItemId);
        }
        writer.WriteEndElement(); // ItemIds
        if (this.SavedCopyDestinationFolderId != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SavedItemFolderId);
            this.SavedCopyDestinationFolderId.WriteToXml(writer);
            writer.WriteEndElement();
        }
    }
}
exports.SendItemRequest = SendItemRequest;
//# sourceMappingURL=SendItemRequest.js.map