"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveCopyRequest = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class MoveCopyRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.destinationFolderId = null;
    }
    get DestinationFolderId() {
        return this.destinationFolderId;
    }
    set DestinationFolderId(value) {
        this.destinationFolderId = value;
    }
    AddIdsToJson(jsonObject, service) { throw new Error("MoveCopyRequest.ts - AddIdsToJson : Not implemented."); }
    Validate() {
        //EwsUtilities.ValidateParam(this.DestinationFolderId, "DestinationFolderId");
        this.DestinationFolderId.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ToFolderId);
        this.DestinationFolderId.WriteToXml(writer);
        writer.WriteEndElement();
        this.WriteIdsToXml(writer);
    }
    /**@internal */
    WriteIdsToXml(writer) { throw new Error("MoveCopyRequest.ts - WriteIdsToXml : Abstract - must implement."); }
}
exports.MoveCopyRequest = MoveCopyRequest;
//# sourceMappingURL=MoveCopyRequest.js.map