"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkAsJunkRequest = void 0;
const ItemIdWrapperList_1 = require("../../Misc/ItemIdWrapperList");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MarkAsJunkResponse_1 = require("../Responses/MarkAsJunkResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class MarkAsJunkRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.itemIds = new ItemIdWrapperList_1.ItemIdWrapperList();
        this.IsJunk = false;
        this.MoveItem = false;
    }
    get ItemIds() {
        return this.itemIds;
    }
    CreateServiceResponse(service, responseIndex) { return new MarkAsJunkResponse_1.MarkAsJunkResponse(); }
    GetExpectedResponseMessageCount() { return this.itemIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2013; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAsJunkResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAsJunkResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAsJunk; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.ItemIds, "ItemIds");
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.IsJunk, this.IsJunk);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.MoveItem, this.MoveItem);
    }
    /**@internal */
    WriteElementsToXml(writer) { this.itemIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds); }
}
exports.MarkAsJunkRequest = MarkAsJunkRequest;
//# sourceMappingURL=MarkAsJunkRequest.js.map