"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HangingServiceRequestBase = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsLogging_1 = require("../EwsLogging");
const EwsServiceXmlReader_1 = require("../EwsServiceXmlReader");
const HangingRequestDisconnectEventArgs_1 = require("./HangingRequestDisconnectEventArgs");
const HangingRequestDisconnectReason_1 = require("../../Enumerations/HangingRequestDisconnectReason");
const ServiceRequestBase_1 = require("./ServiceRequestBase");
/**
 * @internal Represents an abstract, hanging service request.
 */
class HangingServiceRequestBase extends ServiceRequestBase_1.ServiceRequestBase {
    // /**
    //  * ews-javascript-api:  FetchStream object
    //  */
    // private stream: FetchStream;
    /**
     * @internal Initializes a new instance of the **HangingServiceRequestBase** class.
     *
     * @param   {ExchangeService}   	service                	The service.
     * @param   {HandleResponseObject} 	handler   				Callback delegate to handle response objects.
     * @param   {number}   				heartbeatFrequency      Frequency at which we expect heartbeats, in milliseconds.
     */
    constructor(service, handler, heartbeatFrequency) {
        super(service);
        this.responseHandler = null;
        this.response = null;
        this.request = null;
        this.heartbeatFrequencyMilliseconds = 0;
        /**
         * @internal Occurs when the hanging request is disconnected. events converted into array of delagte function
         */
        this.OnDisconnect = [];
        this.IsConnected = false;
        /**
         * Stores chunked data from fetch FetchStream
         */
        this.chunk = '';
        this.responseHandler = handler;
        this.heartbeatFrequencyMilliseconds = heartbeatFrequency;
    }
    Disconnect(reason = HangingRequestDisconnectReason_1.HangingRequestDisconnectReason.UserInitiated, exception = null) {
        if (this.IsConnected) {
            this.Service.XHRApi.disconnect();
            this.InternalOnDisconnect(reason, exception);
        }
    }
    /**
     * @internal Exectures the request.
     */
    InternalExecute() {
        //lock (this.lockObject){
        //this.response = this.ValidateAndEmitRequest(this.BuildXHR());
        return new Promise((successDelegate, errorDelegate) => {
            var request = this.BuildXHR();
            //this.ReadResponsePrivate(response);
            this.ValidateAndEmitRequest(request, (progress) => {
                switch (progress.type) {
                    case "data":
                        this.InternalOnConnect();
                        progress.data = progress.data.trim();
                        this.chunk += progress.data;
                        let _continue = false;
                        let xml = '';
                        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.chunk)) {
                            //"<Envelope>indexOf</Envelope>"
                            let start = this.chunk.indexOf("<Envelope");
                            let end = this.chunk.indexOf("</Envelope>");
                            if (start >= 0 && end > 0) {
                                xml = this.chunk.substr(start, end - start + 11);
                                this.chunk = this.chunk.substr(end + 11);
                                _continue = true;
                            }
                        }
                        if (_continue) {
                            var dom = new ExtensionMethods_1.DOMParser();
                            var xml2js = new ExtensionMethods_1.xml2JsObject();
                            let req;
                            try {
                                //req = xml2js.parseXMLNode(dom.parseFromString(xml, "text/xml").documentElement, true);
                                //EwsLogging.DebugLog(req, true);
                                EwsLogging_1.EwsLogging.DebugLog(xml, true);
                                var ewsXmlReader = new EwsServiceXmlReader_1.EwsServiceXmlReader(xml, this.Service);
                                EwsLogging_1.EwsLogging.DebugLog(ewsXmlReader.JsObject, true);
                                //var serviceResponse = 
                                this.ParseResponses(ewsXmlReader.JsObject);
                                // if (successDelegate)
                                //     successDelegate(serviceResponse || xml);
                                // else {
                                //     if (errorDelegate)
                                //         errorDelegate(xml);
                                // }
                            }
                            catch (error) {
                                if (errorDelegate)
                                    errorDelegate(error);
                            }
                        }
                        break;
                    case "header":
                        this.InternalOnConnect();
                        if (this.OnResponseHeader && typeof this.OnResponseHeader === 'function') {
                            this.OnResponseHeader(progress.headers);
                        }
                        //console.log(meta);
                        break;
                    case "end":
                        this.InternalOnDisconnect(HangingRequestDisconnectReason_1.HangingRequestDisconnectReason.Clean, null);
                        break;
                    case "error":
                        this.Disconnect(HangingRequestDisconnectReason_1.HangingRequestDisconnectReason.Exception, progress.error);
                        if (errorDelegate) {
                            errorDelegate(progress.error);
                        }
                        break;
                    default:
                        break;
                }
            }).then((xhrResponse) => {
                //console.log(xhrResponse);
                //successDelegate(void 0);
            }, (resperr) => {
                if (resperr.status && resperr.getAllResponseHeaders) {
                    EwsLogging_1.EwsLogging.Log("Error in calling service, error code: " + resperr.status + "\r\n " + resperr.getAllResponseHeaders());
                }
                else {
                    EwsLogging_1.EwsLogging.Log("Error in calling service, error code: " + (resperr.status || resperr.message));
                }
                if (errorDelegate)
                    errorDelegate(this.ProcessWebException(resperr) || resperr);
            });
        });
    }
    /**
     * Perform any bookkeeping needed when we connect
     */
    InternalOnConnect() {
        if (!this.IsConnected) {
            this.IsConnected = true;
            // Trace Http headers
            // this.Service.ProcessHttpResponseHeaders(
            //     TraceFlags.EwsResponseHttpHeaders,
            //     this.response);
            //info: //ref: - not needed, no threadpool, handled in 
            // ThreadPool.QueueUserWorkItem(
            //     new WaitCallback(this.ParseResponses));
        }
    }
    /**
     * Perform any bookkeeping needed when we disconnect (cleanly or forcefully)
     *
     * @param   {HangingRequestDisconnectReason}    reason      [description]
     * @param   {Exception}                         exception   [description]
     */
    InternalOnDisconnect(reason, exception) {
        if (this.IsConnected) {
            this.IsConnected = false;
            if (this.OnDisconnect && ExtensionMethods_1.ArrayHelper.isArray(this.OnDisconnect)) {
                try {
                    this.OnDisconnect.forEach((OnDisconnect) => {
                        OnDisconnect(this, new HangingRequestDisconnectEventArgs_1.HangingRequestDisconnectEventArgs(reason, exception));
                    });
                }
                catch (e) { }
            }
        }
    }
    //* @return  {any}   parsed response object.
    /**
     * Parses the responses.
     *
     * @param   {any}   state   Notification state.
     */
    ParseResponses(state) {
        try {
            let responseObject = this.ReadResponseXmlJsObject(state);
            this.responseHandler(responseObject);
        }
        catch (error) {
            this.Disconnect(HangingRequestDisconnectReason_1.HangingRequestDisconnectReason.Exception, error);
            console.log("error parsing object....\n TODO: Implement better parse error for Notifications");
            //console.log(state);
        }
        // try
        //     {
        //         Guid traceId = Guid.Empty;
        //         HangingTraceStream tracingStream = null;
        //         MemoryStream responseCopy = null;
        //         try
        //         {
        //             bool traceEwsResponse = this.Service.IsTraceEnabledFor(TraceFlags.EwsResponse);
        //             using (Stream responseStream = this.response.GetResponseStream())
        //             {
        //                 responseStream.ReadTimeout = 2 * this.heartbeatFrequencyMilliseconds;
        //                 tracingStream = new HangingTraceStream(responseStream, this.Service);
        //                 // EwsServiceMultiResponseXmlReader.Create causes a read.
        //                 if (traceEwsResponse)
        //                 {
        //                     responseCopy = new MemoryStream();
        //                     tracingStream.SetResponseCopy(responseCopy);
        //                 }
        //                 EwsServiceMultiResponseXmlReader ewsXmlReader = EwsServiceMultiResponseXmlReader.Create(tracingStream, this.Service);
        //                 while (this.IsConnected)
        //                 {
        //                     object responseObject = null;
        //                     if (traceEwsResponse)
        //                     {
        //                         try
        //                         {
        //                             responseObject = this.ReadResponse(ewsXmlReader, this.response.Headers);
        //                         }
        //                         finally
        //                         {
        //                             this.Service.TraceXml(TraceFlags.EwsResponse, responseCopy);
        //                         }
        //                         // reset the stream collector.
        //                         responseCopy.Close();
        //                         responseCopy = new MemoryStream();
        //                         tracingStream.SetResponseCopy(responseCopy);
        //                     }
        //                     else
        //                     {
        //                         responseObject = this.ReadResponse(ewsXmlReader, this.response.Headers);
        //                     }
        //                     this.responseHandler(responseObject);
        //                 }
        //             }
        //         }
        //         catch (TimeoutException ex)
        //         {
        //             // The connection timed out.
        //             this.Disconnect(HangingRequestDisconnectReason.Timeout, ex);
        //             return;
        //         }
        //         catch (IOException ex)
        //         {
        //             // Stream is closed, so disconnect.
        //             this.Disconnect(HangingRequestDisconnectReason.Exception, ex);
        //             return;
        //         }
        //         catch (HttpException ex)
        //         {
        //             // Stream is closed, so disconnect.
        //             this.Disconnect(HangingRequestDisconnectReason.Exception, ex);
        //             return;
        //         }
        //         catch (WebException ex)
        //         {
        //             // Stream is closed, so disconnect.
        //             this.Disconnect(HangingRequestDisconnectReason.Exception, ex);
        //             return;
        //         }
        //         catch (ObjectDisposedException ex)
        //         {
        //             // Stream is closed, so disconnect.
        //             this.Disconnect(HangingRequestDisconnectReason.Exception, ex);
        //             return;
        //         }
        //         catch (NotSupportedException)
        //         {
        //             // This is thrown if we close the stream during a read operation due to a user method call.
        //             // Trying to delay closing until the read finishes simply results in a long-running connection.
        //             this.Disconnect(HangingRequestDisconnectReason.UserInitiated, null);
        //             return;
        //         }
        //         catch (XmlException ex)
        //         {
        //             // Thrown if server returned no XML document.
        //             this.Disconnect(HangingRequestDisconnectReason.UserInitiated, ex);
        //             return;
        //         }
        //         finally
        //         {
        //             if (responseCopy != null)
        //             {
        //                 responseCopy.Dispose();
        //                 responseCopy = null;
        //             }
        //         }
        //     }
        //     catch (ServiceLocalException exception)
        //     {
        //         this.Disconnect(HangingRequestDisconnectReason.Exception, exception);
        //     }
    }
    //ReadPreamble(ewsXmlReader: EwsServiceXmlReader): void { throw new Error("HangingServiceRequestBase.ts - ReadPreamble : Not implemented."); }
    /* ews-javascript-api specific */
    /**
     * Validates request parameters, and emits the request to the server.
     *
     * @param   {IXHROptions}               request   The request.
     * @return  {Promise<XMLHttpRequest>}   The response returned by the server.
     */
    ValidateAndEmitRequest(request, progressDelegate) {
        this.Validate();
        //var request = this.BuildXHR();
        if (this.Service.SendClientLatencies) {
            var clientStatisticsToAdd = '';
            //lock(clientStatisticsCache)
            //{
            if (ServiceRequestBase_1.ServiceRequestBase.clientStatisticsCache.length > 0) {
                clientStatisticsToAdd = ServiceRequestBase_1.ServiceRequestBase.clientStatisticsCache[0];
                ServiceRequestBase_1.ServiceRequestBase.clientStatisticsCache.splice(0, 1);
            }
            //}
            if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(clientStatisticsToAdd)) {
                if (request.headers[ServiceRequestBase_1.ServiceRequestBase.ClientStatisticsRequestHeader]) {
                    request.headers[ServiceRequestBase_1.ServiceRequestBase.ClientStatisticsRequestHeader] =
                        request.headers[ServiceRequestBase_1.ServiceRequestBase.ClientStatisticsRequestHeader] + clientStatisticsToAdd;
                }
                else {
                    request.headers[ServiceRequestBase_1.ServiceRequestBase.ClientStatisticsRequestHeader] = clientStatisticsToAdd;
                }
            }
        }
        //var startTime = Date.now();// DateTime.UtcNow;
        //var response = XHR(request);
        EwsLogging_1.EwsLogging.DebugLog("sending ews request");
        EwsLogging_1.EwsLogging.DebugLog(Object.assign(Object.assign({}, request), { headers: Object.assign(Object.assign({}, request.headers), { Authorization: "REDACTED" }) }), true);
        return this.Service.XHRApi.xhrStream(request, progressDelegate);
        // return new Promise((successDelegate, errorDelegate) => {
        //     this.stream = new FetchStream(this.Service.Url.ToString(), request);
        //     this.stream.on("data", (chunk) => {
        //         //console.log(chunk.toString());
        //         progressDelegate(chunk.toString());
        //     });
        //     this.stream.on("meta", (meta) => {
        //         if (this.OnResponseHeader && typeof this.OnResponseHeader === 'function') {
        //             this.OnResponseHeader(meta["responseHeaders"])
        //         }
        //         //console.log(meta);
        //     });
        //     this.stream.on("end", (data) => {
        //         this.IsConnected = false;
        //     });
        //     this.stream.on('error', (error) => {
        //         this.Disconnect(HangingRequestDisconnectReason.Exception, <any>error);
        //         if (errorDelegate) {
        //             errorDelegate(error);
        //         }
        //     });
        // });
        //try
        //{
        //    var response = this.GetEwsHttpWebResponse(request);
        //}
        //finally {
        //    if (this.service.SendClientLatencies) {
        //        int clientSideLatency = (int)(DateTime.UtcNow - startTime).TotalMilliseconds;
        //        string requestId = string.Empty;
        //        string soapAction = this.GetType().Name.Replace("Request", string.Empty);
        //        if (response != null && response.Headers != null) {
        //            foreach(string requestIdHeader in ServiceRequestBase.RequestIdResponseHeaders)
        //            {
        //                string requestIdValue = response.Headers.Get(requestIdHeader);
        //                if (!string.IsNullOrEmpty(requestIdValue)) {
        //                    requestId = requestIdValue;
        //                    break;
        //                }
        //            }
        //        }
        //        StringBuilder sb = new StringBuilder();
        //        sb.Append("MessageId=");
        //        sb.Append(requestId);
        //        sb.Append(",ResponseTime=");
        //        sb.Append(clientSideLatency);
        //        sb.Append(",SoapAction=");
        //        sb.Append(soapAction);
        //        sb.Append(";");
        //        lock(clientStatisticsCache)
        //        {
        //            clientStatisticsCache.Add(sb.ToString());
        //        }
        //    }
        //}
        //return response;
    }
}
exports.HangingServiceRequestBase = HangingServiceRequestBase;
HangingServiceRequestBase.BufferSize = 4096;
//# sourceMappingURL=HangingServiceRequestBase.js.map