"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserAvailabilityRequest = void 0;
const AvailabilityData_1 = require("../../Enumerations/AvailabilityData");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceError_1 = require("../../Enumerations/ServiceError");
const GetUserAvailabilityResults_1 = require("../../Misc/Availability/GetUserAvailabilityResults");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const AttendeeAvailability_1 = require("../Responses/AttendeeAvailability");
const SuggestionsResponse_1 = require("../Responses/SuggestionsResponse");
const ServiceResponseCollection_1 = require("../Responses/ServiceResponseCollection");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/** @internal */
class GetUserAvailabilityRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    // private attendees: AttendeeInfo[];//System.Collections.Generic.IEnumerable<AttendeeInfo>; - no need of backing field
    // private timeWindow: TimeWindow;
    // private requestedData: AvailabilityData;
    // private options: AvailabilityOptions;
    constructor(service) {
        super(service);
        this.Attendees = []; //System.Collections.Generic.IEnumerable<AttendeeInfo>;
        this.TimeWindow = null;
        this.RequestedData = AvailabilityData_1.AvailabilityData.FreeBusyAndSuggestions;
        this.Options = null;
    }
    get EmitTimeZoneHeader() { return true; }
    get IsFreeBusyViewRequested() { return this.RequestedData == AvailabilityData_1.AvailabilityData.FreeBusy || this.RequestedData == AvailabilityData_1.AvailabilityData.FreeBusyAndSuggestions; }
    get IsSuggestionsViewRequested() { return this.RequestedData == AvailabilityData_1.AvailabilityData.Suggestions || this.RequestedData == AvailabilityData_1.AvailabilityData.FreeBusyAndSuggestions; }
    Execute() { return this.InternalExecute(); }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetUserAvailabilityResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetUserAvailabilityRequest; }
    ParseResponse(jsonBody) {
        var serviceResponse = new GetUserAvailabilityResults_1.GetUserAvailabilityResults();
        if (this.IsFreeBusyViewRequested) {
            serviceResponse.AttendeesAvailability = new ServiceResponseCollection_1.ServiceResponseCollection();
            var responseArray = jsonBody[XmlElementNames_1.XmlElementNames.FreeBusyResponseArray];
            var responseMessages = responseArray[XmlElementNames_1.XmlElementNames.FreeBusyResponse];
            if (!Array.isArray(responseMessages)) {
                responseMessages = [responseMessages];
            }
            for (var responseMessage of responseMessages) {
                var freeBusyResponse = new AttendeeAvailability_1.AttendeeAvailability();
                freeBusyResponse.LoadFromXmlJsObject(responseMessage[XmlElementNames_1.XmlElementNames.ResponseMessage], this.Service);
                if (freeBusyResponse.ErrorCode == ServiceError_1.ServiceError.NoError) {
                    freeBusyResponse.LoadFreeBusyViewFromXmlJsObject(responseMessage[XmlElementNames_1.XmlElementNames.FreeBusyView], this.Options.RequestedFreeBusyView, this.Service);
                }
                serviceResponse.AttendeesAvailability.Add(freeBusyResponse);
            }
        }
        if (this.IsSuggestionsViewRequested) {
            serviceResponse.SuggestionsResponse = new SuggestionsResponse_1.SuggestionsResponse();
            var suggestionResponse = jsonBody[XmlElementNames_1.XmlElementNames.SuggestionsResponse];
            serviceResponse.SuggestionsResponse.LoadFromXmlJsObject(suggestionResponse[XmlElementNames_1.XmlElementNames.ResponseMessage], this.Service);
            if (serviceResponse.SuggestionsResponse.ErrorCode == ServiceError_1.ServiceError.NoError) {
                serviceResponse.SuggestionsResponse.LoadSuggestedDaysFromXml(suggestionResponse, this.Service);
            }
        }
        return serviceResponse;
    }
    Validate() {
        super.Validate();
        this.Options.Validate(this.TimeWindow.Duration);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        // Only serialize the TimeZone property against an Exchange 2007 SP1 server.
        // Against Exchange 2010, the time zone is emitted in the request's SOAP header.
        if (writer.Service.RequestedServerVersion == ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1) {
            //todo: implement TimeZone and then LegacyAvailabilityTimeZone
            // var legacyTimeZone:LegacyAvailabilityTimeZone = new LegacyAvailabilityTimeZone(writer.Service.TimeZone);
            // legacyTimeZone.WriteToXml(writer, XmlElementNames.TimeZone);
        }
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.MailboxDataArray);
        for (var attendee of this.Attendees) {
            attendee.WriteToXml(writer);
        }
        writer.WriteEndElement(); // MailboxDataArray
        this.Options.WriteToXml(writer, this);
    }
}
exports.GetUserAvailabilityRequest = GetUserAvailabilityRequest;
//# sourceMappingURL=GetUserAvailabilityRequest.js.map