"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetStreamingEventsRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetStreamingEventsResponse_1 = require("../Responses/GetStreamingEventsResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const HangingServiceRequestBase_1 = require("./HangingServiceRequestBase");
/**
 * @internal Represents a GetStreamingEvents request.
 */
class GetStreamingEventsRequest extends HangingServiceRequestBase_1.HangingServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetStreamingEventsRequest** class.
     *
     * @param   {ExchangeService}   	service                The service.
     * @param   {HandleResponseObject} 	serviceObjectHandler   Callback method to handle response objects received.
     * @param   {string[]}   			subscriptionIds        List of subscription ids to listen to on this request.
     * @param   {number}   				connectionTimeout      Connection timeout, in minutes.
     */
    constructor(service, serviceObjectHandler, subscriptionIds, connectionTimeout) {
        super(service, serviceObjectHandler, GetStreamingEventsRequest.heartbeatFrequency);
        this.subscriptionIds = subscriptionIds;
        this.connectionTimeout = connectionTimeout;
    }
    /**
     * @internal Allow test code to change heartbeat value
     * /remarks/	set only.
     */
    static set HeartbeatFrequency(value) {
        this.heartbeatFrequency = value;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2010_SP1; }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetStreamingEventsResponse; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetStreamingEvents; }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsBody) {
        var jsResponseMessages = jsBody[XmlElementNames_1.XmlElementNames.ResponseMessages];
        let response = new GetStreamingEventsResponse_1.GetStreamingEventsResponse(this);
        response.LoadFromXmlJsObject(jsResponseMessages[XmlElementNames_1.XmlElementNames.GetStreamingEventsResponseMessage], this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SubscriptionIds);
        for (let id of this.subscriptionIds) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SubscriptionId, id);
        }
        writer.WriteEndElement();
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ConnectionTimeout, this.connectionTimeout);
    }
}
exports.GetStreamingEventsRequest = GetStreamingEventsRequest;
GetStreamingEventsRequest.HeartbeatFrequencyDefault = 45000;
GetStreamingEventsRequest.heartbeatFrequency = GetStreamingEventsRequest.HeartbeatFrequencyDefault;
//# sourceMappingURL=GetStreamingEventsRequest.js.map