"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetRoomsRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetRoomsResponse_1 = require("../Responses/GetRoomsResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetRooms request.
 *
 * @sealed
 */
class GetRoomsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetRoomsRequest** class.
     *
     * @param   {service}   service   The service.
     */
    constructor(service) {
        super(service);
        this.roomList = null;
    }
    /**
     * @internal Gets or sets the room list to retrieve rooms from.
     */
    get RoomList() {
        return this.roomList;
    }
    set RoomList(value) {
        this.roomList = value;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetRoomsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetRoomsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetRoomsRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetRoomsResponse_1.GetRoomsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        //this.RoomList.WriteToXml(writer, XmlNamespace.Messages, XmlElementNames.RoomList);
        this.RoomList.WriteToXml(writer, XmlElementNames_1.XmlElementNames.RoomList, XmlNamespace_1.XmlNamespace.Messages); //info: temp workaround github #52 
    }
}
exports.GetRoomsRequest = GetRoomsRequest;
//# sourceMappingURL=GetRoomsRequest.js.map