"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNonIndexableItemStatisticsRequest = void 0;
const GetNonIndexableItemStatisticsResponse_1 = require("../Responses/GetNonIndexableItemStatisticsResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents the GetNonIndexableItemStatistics response.
 */
class GetNonIndexableItemStatisticsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetNonIndexableItemStatisticsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Mailboxes
         */
        this.Mailboxes = null;
        /**
         * Whether to search archive only
         */
        this.SearchArchiveOnly = false;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetNonIndexableItemStatisticsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetNonIndexableItemStatisticsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetNonIndexableItemStatistics;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetNonIndexableItemStatisticsResponse_1.GetNonIndexableItemStatisticsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (this.Mailboxes == null || this.Mailboxes.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.MailboxesParameterIsNotSpecified);
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Mailboxes);
        for (let mailbox of this.Mailboxes) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LegacyDN, mailbox);
        }
        writer.WriteEndElement();
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SearchArchiveOnly, this.SearchArchiveOnly);
    }
}
exports.GetNonIndexableItemStatisticsRequest = GetNonIndexableItemStatisticsRequest;
//# sourceMappingURL=GetNonIndexableItemStatisticsRequest.js.map