"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetHoldOnMailboxesRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetHoldOnMailboxesResponse_1 = require("../Responses/GetHoldOnMailboxesResponse");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetHoldOnMailboxesRequest request.
 *
 * @sealed
 */
class GetHoldOnMailboxesRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetHoldOnMailboxesRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Hold id
         */
        this.HoldId = null;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetHoldOnMailboxesResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetHoldOnMailboxesResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetHoldOnMailboxes;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetHoldOnMailboxesResponse_1.GetHoldOnMailboxesResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.HoldId)) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.HoldIdParameterIsNotSpecified);
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.HoldId, this.HoldId);
    }
}
exports.GetHoldOnMailboxesRequest = GetHoldOnMailboxesRequest;
//# sourceMappingURL=GetHoldOnMailboxesRequest.js.map