"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetEventsRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const GetEventsResponse_1 = require("../Responses/GetEventsResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal GetEvents request
 */
class GetEventsRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **GetEventsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.subscriptionId = null;
        this.watermark = null;
    }
    /**
     * Gets or sets the subscription id.
     *
     * @value	The subscription id.
     */
    get SubscriptionId() {
        return this.subscriptionId;
    }
    set SubscriptionId(value) {
        this.subscriptionId = value;
    }
    /**
     * Gets or sets the watermark.
     *
     * @value	The watermark.
     */
    get Watermark() {
        return this.watermark;
    }
    set Watermark(value) {
        this.watermark = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {GetEventsResponse}		Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new GetEventsResponse_1.GetEventsResponse();
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return 1;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetEventsResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetEventsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetEvents;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParam(this.SubscriptionId, "SubscriptionId");
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParam(this.Watermark, "Watermark");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SubscriptionId, this.SubscriptionId);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Watermark, this.Watermark);
    }
}
exports.GetEventsRequest = GetEventsRequest;
//# sourceMappingURL=GetEventsRequest.js.map