"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyFolderRequest = void 0;
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const DeleteRequest_1 = require("./DeleteRequest");
/** @internal */
class EmptyFolderRequest extends DeleteRequest_1.DeleteRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.DeleteSubFolders = false;
        this.folderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
    }
    get FolderIds() {
        return this.folderIds;
    }
    CreateServiceResponse(service, responseIndex) { return new ServiceResponse_1.ServiceResponse(); }
    GetExpectedResponseMessageCount() { return this.FolderIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2010_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.EmptyFolderResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.EmptyFolderResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.EmptyFolder; }
    InternalToJson(body) { throw new Error("EmptyFolderRequest.ts - InternalToJson : Not implemented."); }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.FolderIds, "FolderIds");
        this.FolderIds.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.DeleteSubFolders, this.DeleteSubFolders);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        this.FolderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.FolderIds);
    }
}
exports.EmptyFolderRequest = EmptyFolderRequest;
//# sourceMappingURL=EmptyFolderRequest.js.map