"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAttachmentRequest = void 0;
const DeleteAttachmentResponse_1 = require("../Responses/DeleteAttachmentResponse");
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
/**
 * @internal Represents a DeleteAttachment request.
 * @sealed
 */
class DeleteAttachmentRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **DeleteAttachmentRequest** class.
     *
     * @param   {ExchangeService}       service             The service.
     * @param   {ServiceErrorHandling}  errorHandlingMode   Indicates how errors should be handled.
     */
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.attachments = [];
    }
    /**
     * Gets the attachments.
     * @value   The attachments.
     */
    get Attachments() {
        return this.attachments;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}            responseIndex   Index of the response.
     * @return  {DeleteAttachmentResponse}     Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new DeleteAttachmentResponse_1.DeleteAttachmentResponse(this.Attachments[responseIndex]);
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return this.Attachments.length;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteAttachmentResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteAttachmentResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteAttachment;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParamCollection(this.Attachments, "Attachments");
        for (let i = 0; i < this.Attachments.length; i++) {
            EwsUtilities_1.EwsUtilities.ValidateParam(this.Attachments[i].Id, ExtensionMethods_1.StringHelper.Format("Attachment[{0}].Id", i));
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.AttachmentIds);
        for (let attachment of this.Attachments) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.AttachmentId);
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Id, attachment.Id);
            writer.WriteEndElement();
        }
        writer.WriteEndElement();
    }
}
exports.DeleteAttachmentRequest = DeleteAttachmentRequest;
//# sourceMappingURL=DeleteAttachmentRequest.js.map