"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegateManagementRequestBase = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents an abstract delegate management request.
 *
 * @typeparam   {TResponse}     The type of the response.
 */
class DelegateManagementRequestBase extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **DelegateManagementRequestBase<TResponse>** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.mailbox = null;
    }
    /**
     *  Gets or sets the mailbox.
     *
     * @value    The mailbox.
     */
    get Mailbox() {
        return this.mailbox;
    }
    set Mailbox(value) {
        this.mailbox = value;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<TResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = this.CreateResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.Mailbox, "Mailbox");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        this.Mailbox.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Mailbox, XmlNamespace_1.XmlNamespace.Messages);
    }
}
exports.DelegateManagementRequestBase = DelegateManagementRequestBase;
//# sourceMappingURL=DelegateManagementRequestBase.js.map