"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateRequest = void 0;
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class CreateRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.parentFolderId = null;
        this.objects = []; // null;
    }
    set Objects(value) {
        this.objects = value;
    }
    get Objects() {
        return this.objects;
    }
    set ParentFolderId(value) {
        this.parentFolderId = value;
    }
    get ParentFolderId() {
        return this.parentFolderId;
    }
    AddJsonProperties(jsonRequest, service) { throw new Error("CreateRequest.ts - AddJsonProperties : Not implemented."); }
    GetExpectedResponseMessageCount() { return this.Objects.length; }
    GetObjectCollectionXmlElementName() { throw new Error("CreateRequest.ts - GetObjectCollectionXmlElementName : abstract - must implement."); }
    GetParentFolderXmlElementName() { throw new Error("CreateRequest.ts - GetParentFolderXmlElementName : abstract - must implement."); }
    Validate() {
        super.Validate();
        if (this.ParentFolderId != null) {
            this.ParentFolderId.Validate(this.Service.RequestedServerVersion);
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        if (this.ParentFolderId != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, this.GetParentFolderXmlElementName());
            this.ParentFolderId.WriteToXml(writer);
            writer.WriteEndElement();
        }
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, this.GetObjectCollectionXmlElementName());
        for (var obj of this.objects) {
            obj.WriteToXml(writer);
        }
        writer.WriteEndElement();
    }
}
exports.CreateRequest = CreateRequest;
//# sourceMappingURL=CreateRequest.js.map