"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateFolderRequest = void 0;
const CreateFolderResponse_1 = require("../Responses/CreateFolderResponse");
const XmlElementNames_1 = require("../XmlElementNames");
//import {EwsUtilities} from "../EwsUtilities";
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const Strings_1 = require("../../Strings");
const CreateRequest_1 = require("./CreateRequest");
/** @internal */
class CreateFolderRequest extends CreateRequest_1.CreateRequest {
    get Folders() {
        return this.Objects;
    }
    set Folders(value) {
        this.Objects = value;
    }
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
    }
    CreateServiceResponse(service, responseIndex) {
        //return new CreateFolderResponse(<Folder>EwsUtilities.GetEnumeratedObjectAt(this.Folders, responseIndex));
        if (this.Folders.length <= responseIndex) {
            throw new Error(Strings_1.Strings.IEnumerableDoesNotContainThatManyObject);
        }
        return new CreateFolderResponse_1.CreateFolderResponse(this.Folders[responseIndex]);
    }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetObjectCollectionXmlElementName() { return XmlElementNames_1.XmlElementNames.Folders; }
    GetParentFolderXmlElementName() { return XmlElementNames_1.XmlElementNames.ParentFolderId; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateFolderResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateFolderResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateFolder; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.Folders, "Folders");
        // Validate each folder.
        for (var folder of this.Folders) {
            folder.Validate();
        }
    }
}
exports.CreateFolderRequest = CreateFolderRequest;
//# sourceMappingURL=CreateFolderRequest.js.map